*********************************************************************
***** CONFIDENCE IN AUSTRALIAN BANKANOTES - ROBUSTNESS CHECKES ******
********************* DATE: December 2019 ***************************
*************** AUTHORS: KIM NGUYEN AND ANNY FRANCIS ****************
*********************************************************************

/* Open cleaned data file */


use "finaldata.dta",clear
set more off


/* Table A1: Will receive counterfeits */

quietly reg willgetcf gender i.agegroup1 i.incometier hadacf problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq i.state area i.household i.employment  i.countryofbirth i.year, vce(robust)
estpost margins, dydx(*)
eststo m1
quietly logit willgetcf gender i.agegroup1 i.incometier hadacf problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq i.state area i.household i.employment  i.countryofbirth  i.year, vce(robust)
estpost margins, dydx(*)
eststo m2
quietly ologit willgetcf_g1 gender i.agegroup1 i.incometier hadacf problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq i.state area i.household i.employment  i.countryofbirth i.year, vce(robust)
estpost margins, dydx(*)
eststo m3
quietly ologit willgetcf_g2 gender i.agegroup1 i.incometier hadacf problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq i.state area i.household i.employment  i.countryofbirth i.year, vce(robust)
estpost margins, dydx(*)
eststo m4
quietly probit willgetcf_v2 gender i.agegroup1 i.incometier hadacf problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq i.state area i.household i.employment  i.countryofbirth i.year, vce(robust)
estpost margins, dydx(*)
eststo m5
esttab m1 m2 m3 m4 m5 using "appendix1.csv", se margin title(Regressions) star(* 0.10 ** 0.05 *** 0.01)  replace 
eststo clear 



/* Table A2: Counterfeit problem and Confident in the system*/

quietly reg cfproblem gender i.agegroup1 i.incometier hadacf problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq i.state area i.household i.employment  i.countryofbirth i.year, vce(robust)
estpost margins, dydx(*)
eststo m1
quietly logit cfproblem gender i.agegroup1 i.incometier hadacf problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq i.state area i.household i.employment  i.countryofbirth  i.year, vce(robust)
estpost margins, dydx(*)
eststo m2
quietly reg confsystems gender i.agegroup1 i.incometier hadacf problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq i.state area i.household i.employment  i.countryofbirth i.year, vce(robust)
estpost margins, dydx(*)
eststo m3
quietly logit confsystems gender i.agegroup1 i.incometier hadacf problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq i.state area i.household i.employment  i.countryofbirth  i.year, vce(robust)
estpost margins, dydx(*)
eststo m4
quietly ologit confsystems_g2 gender i.agegroup1 i.incometier hadacf problemsusing i.cashdaily  i.checknote i.heardngb tellscore tellscoresq i.state area i.household i.employment  i.countryofbirth i.year, vce(robust)
estpost margins, dydx(*)
eststo m5
esttab m1 m2 m3 m4 m5 using "appendix2.csv", se margin title(Regressions) star(* 0.10 ** 0.05 *** 0.01)  replace 
eststo clear 



